#Note:
#	1.Set Workspace path
#CDIR=$(shell pwd)
TARGET_ROOT_DIR		:= /mnt/hgfs/F/ZKSilkID_Demo_V2.0.A.2

#Note:
#	1.core board define
#ZMM100 := y
#ZMM220 := y
STD_LINUX :=y
#ZEN510_24 :=y



# Binary file output path
#export DEST_PATH		:= /var/tftpboot

ifdef ZMM220
	export ARCH		:= mips
	export PLATFORM		:= zmm220
	
	#GCC ver 4.1.2
	export CROSS_COMPILE	:= mipsel-linux-
endif

ifdef STD_LINUX
	export ARCH		:= x86
	export PLATFORM		:= linux
endif

ifdef ZEN510_24
	export ARCH		:= mips
	export PLATFORM		:= linux
	export CROSS_COMPILE	:= mipsel-
endif

LD		:= $(CROSS_COMPILE)ld
CC		:= $(CROSS_COMPILE)gcc
CPP		:= $(CROSS_COMPILE)c++
AR		:= $(CROSS_COMPILE)ar
STRIP	:= $(CROSS_COMPILE)strip


TARGET_DIR			:= $(TARGET_ROOT_DIR)/$(ARCH)/$(PLATFORM)
TARGET_LIB_DIR		:= $(TARGET_ROOT_DIR)/$(ARCH)/$(PLATFORM)/src/lib
TARGET_APP_DIR		:= $(TARGET_ROOT_DIR)/$(ARCH)/$(PLATFORM)
TARGET_APP_LIB_DIRS := $(TARGET_ROOT_DIR)/$(ARCH)/$(PLATFORM)/lib/app
BIN					:= $(TARGET_ROOT_DIR)/$(ARCH)/$(PLATFORM)/bin

#Note:
#	1.not used public:-fvisibility=hidden
ENABLE_LOGGING := -DENABLE_LOGGING
#WARNINGFLAG = -Waggregate-return -Wmissing-noreturn -W -Wall
CFLAGS		= -O2 -Wall -nostartfiles -D__GNU__ $(ENABLE_LOGGING) $(WARNINGFLAG)

CXXFLAGS := $(CFLAGS)

#APP_SELF_LIBLS   := $(shell ls  $(TARGET_APP_LIB_DIRS)  | awk  -F"lib" '{print  "-L" "$(TARGET_APP_LIB_DIRS)/" $$0 " " }')
APPPUBLIB := $(APP_SELF_LIBLS) -lm -ldl 

